local MAX_RANGE = 550

function main(self)
	self:AnimationStep()
	local claw = GetClaw()

    if self.State == 0 then
		self:SetImage("CUSTOM_MAGICBULLETS_HOR")
		self:SetAnimation("GAME_CYCLE100")
		self.Flags.AlwaysActive = true
		self.DrawFlags.Mirror = self.Direction == 4
		if self.DrawFlags.Mirror then
			self.AttackRect, self.MoveRect, self.HitRect = {-32,-16,-24,16}, {-28,-16,-20,16}, {-32,-16,-24,16}
			self.SpeedX = -9
		else
			self.AttackRect, self.MoveRect, self.HitRect = {24,-16,32,16}, {20,-16,28,16}, {24,-16,32,16}
			self.SpeedX = 9
		end
		self.HitFlags.Enemy = true
		self.BumpFlags.MagicBullet = true
		self.PhysicsType = PhysicsTypes.Fly
		self.Damage = 15
		self.State = 1
	end

	if self.State == 1 then
		local rect = self.AttackRect
		CreateObject{
			X = self.X + rect.Left + math.random(math.abs(rect.Left - rect.Right)),
			Y = self.Y + rect.Top + math.random(math.abs(rect.Top - rect.Bottom)),
			Z = self.Z + 1,
			name = "Sparkle",
			image = "CUSTOM_SPARKLEBLUE"
		}
		if math.abs(claw.X - self.X) > MAX_RANGE or self:Physics(self.X + self.SpeedX, self.Y) > 0 then
			self:Destroy()
		end
	end
end